﻿using System;
using System.Collections; 
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class EventReminders : System.Web.UI.Page
{
    ContactLogManager contactManager = new ContactLogManager();
    WorkflowCaseManager bioManager = new WorkflowCaseManager(); 

    protected void Page_Load(object sender, EventArgs e)
    {
     
   

    }
    public void EventReminders_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewReferralEventReminders.SelectedIndex = index;

            //int id = Convert.ToInt32(GridViewReferralFollowUps.SelectedValue);
            //calling the right page for different order lab order type
            //Response.Redirect(string.Format("ReferralContactLog.aspx?referralId={0}", id));

            Label fUpType = GridViewReferralEventReminders.SelectedRow.FindControl("LabelFollowupType") as Label;
            if (fUpType != null)
            {
                if (fUpType.Text.Equals("Biomonitoring"))
                {
                    int id = int.Parse(GridViewReferralEventReminders.SelectedDataKey["ReferralId"].ToString());
                    //Response.Redirect(string.Format("LabOrder.aspx?activityId={0}", id));
                    Response.Redirect("Referral.aspx?referralId={0}", id);

                }
                else if (fUpType.Text.Equals("Contact"))
                {
                    //Response.Redirect(string.Format("FragLabOrder.aspx?activityId={0}", id));
                    int referralId = int.Parse(GridViewReferralEventReminders.SelectedDataKey["ReferralId"].ToString());
                    int contactId = int.Parse(GridViewReferralEventReminders.SelectedDataKey["ContactId"].ToString());

                    Response.Redirect("ReferralContact.aspx?referralId={0}&contactId={1}", referralId, contactId);
                }
            }
        }
        else if (e.CommandName == "Snooze")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewReferralEventReminders.SelectedIndex = index;

            //int id = Convert.ToInt32(GridViewReferralFollowUps.SelectedValue);
            //calling the right page for different order lab order type
            //Response.Redirect(string.Format("ReferralContactLog.aspx?referralId={0}", id));

            Label fUpType = GridViewReferralEventReminders.SelectedRow.FindControl("LabelFollowupType") as Label;
            if (fUpType != null)
            {
                if (fUpType.Text.Equals("Biomonitoring"))
                {
                    int activityId = int.Parse(GridViewReferralEventReminders.SelectedDataKey["ActivityId"].ToString());
                    WKF_CASE_ACTIVITY activity = bioManager.getActivityByID(activityId);

                    activity = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>(activity.Serialize());

                    DropDownList ddlPeriod = GridViewReferralEventReminders.SelectedRow.FindControl("DropDownSnoozeDurations") as DropDownList;

                    if (ddlPeriod != null)
                    {
                        if (ddlPeriod.SelectedIndex == 1)
                            activity.FOLLOWUP_REMINDER_DATE = DateTime.Today.AddDays(1);

                        else if (ddlPeriod.SelectedIndex == 2)
                            activity.FOLLOWUP_REMINDER_DATE = DateTime.Today.AddDays(3);

                        else if (ddlPeriod.SelectedIndex == 3)
                            activity.FOLLOWUP_REMINDER_DATE = DateTime.Today.AddDays(7);

                        else if (ddlPeriod.SelectedIndex == 4)
                            activity.FOLLOWUP_REMINDER_DATE = DateTime.Today.AddDays(14);

                        else if (ddlPeriod.SelectedIndex == 5)
                            activity.FOLLOWUP_REMINDER_DATE = DateTime.Today.AddMonths(1);

                    }

                    bioManager.Update(activity);

                    var master = this.Master as RegistryMaster;
                    if (master != null)
                    {
                        master.SetDirtyFlag(false);
                    }

                    //(this.Master as RegistryMaster).SetDirtyFlag(false);

                    GridViewReferralEventReminders.SelectedIndex = -1;

                }
                else if (fUpType.Text.Equals("Contact"))
                {
                    int contactId = int.Parse(GridViewReferralEventReminders.SelectedDataKey["ContactId"].ToString());
                    CONTACT_LOG contact = contactManager.SelectByContactID(contactId);
                    contact.SetAsChangeTrackingRoot();

                    //have to serialize to avoid linq attach exception
                    contact = SerializerUtil.Deserialize<CONTACT_LOG>(contact.Serialize());

                    DropDownList ddlPeriod = GridViewReferralEventReminders.SelectedRow.FindControl("DropDownSnoozeDurations") as DropDownList;

                    if (ddlPeriod != null)
                    {
                        if (ddlPeriod.SelectedIndex == 1)
                            contact.DATE_REMIND_ME_ON = DateTime.Today.AddDays(1);

                        else if (ddlPeriod.SelectedIndex == 2)
                            contact.DATE_REMIND_ME_ON = DateTime.Today.AddDays(3);

                        else if (ddlPeriod.SelectedIndex == 3)
                            contact.DATE_REMIND_ME_ON = DateTime.Today.AddDays(7);

                        else if (ddlPeriod.SelectedIndex == 4)
                            contact.DATE_REMIND_ME_ON = DateTime.Today.AddDays(14);

                        else if (ddlPeriod.SelectedIndex == 5)
                            contact.DATE_REMIND_ME_ON = DateTime.Today.AddMonths(1);

                    }

                    contactManager.Update(contact);
                }
            }
        }

        //re-bind gridview
        GridViewReferralEventReminders.DataBind(); 
    }


    protected void EventReminders_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {

        //Type type = e.ReturnValue as List<FollowupManager.ReferralFollowUp>
        if (e.ReturnValue is List<FollowupManager.ReferralFollowUp>)
        {

            List<FollowupManager.ReferralFollowUp> list = e.ReturnValue as List<FollowupManager.ReferralFollowUp>;

            if (list != null)
            {
                if (list.Count == 0)
                    Response.Redirect("Patients.aspx");
            }            

        }
        
    }
}
